/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.Function;
import intrinsic.flash.display.DisplayObjectContainer;
import intrinsic.flash.display.Sprite;
import intrinsic.mx.controls.Alert;

import org.eclipse.swt.SWT;

public class MessageBox extends Dialog {
	String message = "";

public MessageBox (Shell parent) {
	this (parent, SWT.OK | SWT.ICON_INFORMATION | SWT.APPLICATION_MODAL);
}

public MessageBox (Shell parent, int style) {
	super (parent, checkStyle (style));
	checkSubclass ();
}

static int checkStyle (int style) {
	if ((style & (SWT.PRIMARY_MODAL | SWT.APPLICATION_MODAL | SWT.SYSTEM_MODAL)) == 0) style |= SWT.APPLICATION_MODAL;
	int mask = (SWT.YES | SWT.NO | SWT.OK | SWT.CANCEL | SWT.ABORT | SWT.RETRY | SWT.IGNORE);
	int bits = style & mask;
	if (bits == SWT.OK || bits == SWT.CANCEL || bits == (SWT.OK | SWT.CANCEL)) return style;
	if (bits == SWT.YES || bits == SWT.NO || bits == (SWT.YES | SWT.NO) || bits == (SWT.YES | SWT.NO | SWT.CANCEL)) return style;
	if (bits == (SWT.RETRY | SWT.CANCEL) || bits == (SWT.ABORT | SWT.RETRY | SWT.IGNORE)) return style;
	style = (style & ~mask) | SWT.OK;
	return style;
}

void handleClose (intrinsic.mx.events.CloseEvent event) {
	int result = 0;
	int mask = (SWT.YES | SWT.NO | SWT.OK | SWT.CANCEL | SWT.ABORT | SWT.RETRY | SWT.IGNORE);
	int bits = style & mask;
	switch (event.detail) {
		case Alert.OK:
			result = (bits & SWT.RETRY) != 0 ? result = SWT.RETRY : SWT.OK;
			break;
		case Alert.CANCEL:
			result = (bits & SWT.IGNORE) != 0 ? result = SWT.IGNORE : SWT.CANCEL;
			break;
		case Alert.YES:
			result = SWT.YES;
			break;
		case Alert.NO:
			result = (bits & SWT.ABORT) != 0 ? SWT.ABORT : SWT.NO;
			break;
	}
	//TODO - send an event
	System.out.println(result);
}

native Function handleCloseFunction ()/*{
	return handleClose__Lmx_events_CloseEvent_2;
}*/;

public String getMessage () {
	return message;
}

public int open () {
	String text = message != null ? message : "";
	String title = this.title != null ? this.title : "";
	int mask = (SWT.YES | SWT.NO | SWT.OK | SWT.CANCEL | SWT.ABORT | SWT.RETRY | SWT.IGNORE);
	int flags = 0;
	int defaultButtonFlag = 0;
	String okLabel = null, noLabel = null, cancelLabel = null;
	int bits = style & mask;
	switch (bits) {
		case SWT.OK:
			flags = Alert.OK;
			defaultButtonFlag = Alert.OK;
			break;
		case SWT.CANCEL:
			flags = Alert.CANCEL;
			defaultButtonFlag = Alert.CANCEL;
			break;
		case SWT.OK | SWT.CANCEL:
			flags = Alert.OK | Alert.CANCEL;
			defaultButtonFlag = Alert.OK;
			break;
		case SWT.YES:
			flags = Alert.YES;
			defaultButtonFlag = Alert.YES;
			break;
		case SWT.NO:
			flags = Alert.NO;
			defaultButtonFlag = Alert.NO;
			break;
		case SWT.YES | SWT.NO:
			flags = Alert.YES | Alert.NO;
			defaultButtonFlag = Alert.YES;
			break;
		case SWT.YES | SWT.NO | SWT.CANCEL:			
			flags = Alert.YES | Alert.NO | Alert.CANCEL;
			defaultButtonFlag = Alert.YES;
			break;
		case SWT.RETRY | SWT.CANCEL:
			flags = Alert.OK | Alert.CANCEL;
			defaultButtonFlag = Alert.OK;
			okLabel = SWT.getMessage("SWT_Retry");
			break;
		case SWT.ABORT | SWT.RETRY | SWT.IGNORE:
			flags = Alert.OK | Alert.NO | Alert.CANCEL;
			defaultButtonFlag = Alert.OK;
			okLabel = SWT.getMessage("SWT_Retry");
			noLabel = SWT.getMessage("SWT_Abort");
			cancelLabel =  SWT.getMessage("SWT_Ignore");
			break;
	}
	Alert.okLabel = okLabel;
	Alert.noLabel = noLabel;
	Alert.cancelLabel = cancelLabel;
	DisplayObjectContainer sprite = parent != null ? parent.parentingComponent() : null;
	Alert.show(text, title, flags, (Sprite)sprite, handleCloseFunction (), null, defaultButtonFlag);
	return 0;
}

public void setMessage (String string) {
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	message = string;
}

}
